// ESP32 Dev Module

#define ARDUINO_RUNNING_CORE 1
#define RELAY1 15
#define RELAY2 2
#define BUTTON1 4
#define BUTTON2 5
#define DAC1 25


#include <WiFi.h>


const char* ssid = "PICSimLabWifi";
const char* password = "";

const int MAXTAG = 5;
const int COMMAND_LEN = 1;  // A,B..  1 char

// LZ Define
const String LineEnd = String("\r\n");
String StringBuf;


typedef struct TTags {
  String TagName;
  int TagValue;
};


TTags Tags[MAXTAG];
WiFiServer wifiServer(80);


void setup() {


  // setup serial
  Serial.begin(9600);
  WiFi.begin(ssid, password);

  
  while (WiFi.status() != WL_CONNECTED) {
    delay(500);
    Serial.println("Wait Connecting to WiFi..");
  }


  Serial.println("Connected to the WiFi network");
  Serial.println(WiFi.localIP());
  wifiServer.begin();
  delay(200);

  // define tags
  Tags[0] = (TTags){ "A", 10 };  //  Default Value = 10 TagName = 'A' Analog Output1
  Tags[1] = (TTags){ "C", 0 };   //  Default Value = 0 TagName = 'C' Button1
  Tags[2] = (TTags){ "D", 0 };   //  Default Value = 0 TagName = 'D' Button2
  Tags[3] = (TTags){ "E", 0 };   //  Default Value = 0 TagName = 'E' RELAY1
  Tags[4] = (TTags){ "F", 0 };   //  Default Value = 0 TagName = 'F' RELAY2

  pinMode(BUTTON1, INPUT);  // set pin to input Button 1
  pinMode(BUTTON2, INPUT);  // set pin to input Button 2

  pinMode(RELAY1, OUTPUT);  // set pin to Led 1
  pinMode(RELAY2, OUTPUT);  // set pin to Led 2

  //delay(500);

  // Now set up two tasks to run independently.
  xTaskCreatePinnedToCore( Task1, "Task1", 3*1024, NULL, 2, NULL, ARDUINO_RUNNING_CORE);
  xTaskCreatePinnedToCore( Task2, "Task2", 3*1024  , NULL, 1  , NULL, ARDUINO_RUNNING_CORE);
}

void loop() {
}

/*---------------------- Tasks ---------------------*/

void Task1(void* pvParameters)  // This is a task.
{
  (void)pvParameters;
  for (;;) {
    

  //  Gets
  Tags[1].TagValue = digitalRead(BUTTON1);  // Get Button 1
  Tags[2].TagValue = digitalRead(BUTTON2);  // Get Button 2

  // Sets
  if (Tags[3].TagValue == 1) digitalWrite(RELAY1, HIGH);  else digitalWrite(RELAY1, LOW);
  if (Tags[4].TagValue == 1) digitalWrite(RELAY2, HIGH);  else digitalWrite(RELAY2, LOW);

  // analog Output
  dacWrite(DAC1, Tags[0].TagValue);

  vTaskDelay(1);

  }
}

void Task2(void* pvParameters)  // This is a task.
{

  (void)pvParameters;

  for (;;) {
    String StringBuf, ValueString;
    char inChar;
    int i;

    WiFiClient client = wifiServer.available();

    //vTaskDelay(1000);
    //Serial.println("tak.");   

    if (client) {

      Serial.println("Client Connect.");  

      while (client.connected()) {

        while (client.available() > 0) {
          inChar = client.read();
          StringBuf += inChar;

          if (StringBuf.endsWith(LineEnd)) {

            for (int i = 0; i < MAXTAG; i++) {
              if (StringBuf.startsWith(Tags[i].TagName)) {
                 ValueString = StringBuf.substring(COMMAND_LEN, StringBuf.length() - LineEnd.length());
                 if (ValueString.length() > 0) Tags[i].TagValue = ValueString.toInt();
                 // Alwais TXTCPClient wait result
                 client.print(Tags[i].TagName + Tags[i].TagValue + LineEnd);
                 break;
              }
            }
          }
        }
         
         StringBuf = "";
      }

      client.stop();
      Serial.println("Client Disconnect.");  
 
    }

  
  };  // end for


}  // end task
